## Описание IT-продукта для проекта

**«Персонализированные дидактические материалы для адаптивного электронного обучения в корпоративном секторе»**

### Дизайн-макет

![Дизайн-макет](https://git.herzen.spb.ru/201693/it-project-management/blob/master/ИСР%202.1/дизайн-макет.png)


### Общая концепция

IT-продукт, предназначенный для реализации персонализированных дидактических материалов в системе адаптивного электронного обучения корпоративного сектора, должен представлять собой интегрированную цифровую платформу, ориентированную на поддержку индивидуальных образовательных траекторий сотрудников на основе диагностики их профессиональных компетенций, уровня подготовки и текущих производственных задач.

### Архитектура и ролевая модель

Архитектура системы должна быть модульной и ролево-ориентированной, обеспечивающей разграничение доступа для следующих категорий пользователей:

* обучающиеся (сотрудники);
* преподаватели и тьюторы;
* эксперты-предметники;
* методисты;
* администраторы и HR-специалисты.

Для каждой роли предусматривается отдельный интерфейс с соответствующим набором функций и уровнем доступа к аналитическим данным.

### Пользовательский интерфейс обучающегося

Главный экран обучающегося должен быть реализован в виде персонального дашборда, включающего:

* текущий уровень сформированности профессиональных компетенций;
* динамику обучения и результаты диагностики;
* рекомендованные учебные модули;
* индивидуальный план развития;
* статус прохождения курсов и контрольных мероприятий.

### Адаптивная образовательная траектория

Ключевым элементом интерфейса является визуализация индивидуальной образовательной траектории, представленной в виде последовательности взаимосвязанных модулей, автоматически перестраиваемых на основе:

* входной диагностики;
* результатов формирующего и итогового оценивания;
* профессионального профиля сотрудника;
* требований корпоративной модели компетенций.

Каждый модуль должен включать персонализированные дидактические материалы различных форматов:

* теоретические тексты;
* видеолекции;
* интерактивные симуляции;
* практико-ориентированные кейсы;
* задания разного уровня сложности.

### Система учебной аналитики

Подсистема аналитики должна обеспечивать:

* сбор данных о результатах обучения;
* анализ типичных ошибок;
* отслеживание времени освоения модулей;
* оценку динамики развития компетенций.

Для руководителей и HR-служб интерфейс аналитического модуля должен включать сводные панели мониторинга, позволяющие:

* оценивать эффективность программ обучения;
* выявлять дефициты компетенций;
* планировать индивидуальные и групповые траектории развития персонала.

### Управление дидактическим контентом

Система управления контентом должна предоставлять методистам и экспертам инструменты для:

* конструирования адаптивных учебных сценариев;
* настройки правил персонализации;
* разработки диагностических средств;
* формирования банка заданий, соотнесённого с корпоративной моделью компетенций.

### Визуальное и эргономическое оформление

Визуальный стиль интерфейса рекомендуется выдерживать в корпоративной нейтрально-деловой гамме, обеспечивающей:

* высокую читаемость;
* логическую иерархию информации;
* минимизацию когнитивной нагрузки.

Навигационная структура должна включать следующие основные разделы:

* «Моя траектория»
* «Компетенции»
* «Учебные модули»
* «Оценивание»
* «Аналитика»
* «Обратная связь»

### Итоговая характеристика

В совокупности IT-продукт должен представлять собой научно обоснованную, методически выверенную и технологически устойчивую цифровую образовательную среду, обеспечивающую реализацию принципов адаптивности, персонализации и непрерывного профессионального развития в системе корпоративного электронного обучения.
